// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/util

package com.intellij.spring.model.xml.util;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.*;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static com.intellij.spring.constants.SpringCorePresentationConstants.SPRING_CONSTANT;

/**
 * http://www.springframework.org/schema/util:constantElemType interface.
 *
 * @@updated: spring-util-4.1.xsd
 */
@Presentation(typeName = SPRING_CONSTANT)
@BeanType(provider = SpringConstant.SpringConstantBeanTypeProvider.class)
public interface SpringConstant extends SpringUtilElement, DomSpringBean {

  class SpringConstantBeanTypeProvider implements BeanTypeProvider<SpringConstant> {

    @Override
    public String @NotNull [] getBeanTypeCandidates() {
      return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Nullable
    @Override
    public String getBeanType(SpringConstant constant) {
      final PsiClass psiClass = getStaticFieldType(constant);
      return psiClass != null ? StringUtil.notNullize(psiClass.getQualifiedName()) : "";
    }

    @Nullable
    private static PsiClass getStaticFieldType(SpringConstant constant) {
      final String staticField = constant.getStaticField().getRawText();
      if (StringUtil.isEmptyOrSpaces(staticField) || PlaceholderUtils.getInstance().isDefaultPlaceholder(staticField)) return null;
      int lastPoint = staticField.indexOf("$");
      if (lastPoint == -1) lastPoint = staticField.indexOf(".");

      if (lastPoint >= 0) {
        String className = staticField.substring(0, lastPoint);
        if (StringUtil.isEmptyOrSpaces(className)) return null;
        String fieldName = staticField.substring(lastPoint + 1);
        if (StringUtil.isEmptyOrSpaces(fieldName)) return null;


        Project project = constant.getPsiManager().getProject();
        PsiClass aClass = JavaPsiFacade.getInstance(project).findClass(className, GlobalSearchScope.allScope(project));
        if (aClass != null) {
          PsiField fieldByName = aClass.findFieldByName(fieldName, true);
          if (fieldByName != null) {
            PsiType type = fieldByName.getType();
            if (type instanceof PsiClassType) return ((PsiClassType)type).resolve();
          }
          else {
            for (PsiMethod method : aClass.findMethodsByName(fieldName, true)) {
              PsiType returnType = method.getReturnType();
              if (returnType instanceof PsiClassType) return ((PsiClassType)returnType).resolve();
            }
          }
        }
      }
      return null;
    }
  }


  /**
   * Returns the value of the static-field child.
   *
   * @return the value of the static-field child.
   */
  @NotNull
  @Required
  @Referencing(value = FieldRetrievingFactoryBeanConverter.FieldReferenceRequired.class)
  GenericAttributeValue<String> getStaticField();
}
