// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.xml.beans;

import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.Nullable;

public abstract class SpringValueHolderDefinitionBase implements SpringValueHolderDefinition {

  @Nullable
  @Override
  public String getValueAsString() {
    final GenericDomValue<?> element = getValueElement();
    return element == null ? null : element.getStringValue();
  }

  @Nullable
  @Override
  public SpringBeanPointer<?>  getRefValue() {
    final GenericDomValue<SpringBeanPointer<?>> refElement = getRefElement();
    return refElement == null ? null : refElement.getValue();
  }
}
