// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.xml.beans;

import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
 */
public interface SpringValueHolderDefinition extends TypeHolder {

  @Nullable
  GenericDomValue<?> getValueElement();

  /**
   * Returns value as String.
   *
   * @return {@code null} if {@link #getValueElement()} is {@code null}.
   */
  @Nullable
  String getValueAsString();

  @Nullable
  GenericDomValue<SpringBeanPointer<?>> getRefElement();

  /**
   * Returns ref value.
   *
   * @return {@code null} if {@link #getRefElement()} or its value is {@code null}.
   */
  @Nullable
  SpringBeanPointer<?>  getRefValue();
}
