// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanReplacedMethodConverter;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * http://www.springframework.org/schema/beans:replaced-methodElemType interface.
 */
public interface ReplacedMethod extends DomElement {

  @NonNls String METHOD_REPLACER_CLASS = "org.springframework.beans.factory.support.MethodReplacer";

  /**
   * Returns the value of the name child.
   * <pre>
   * <h3>Attribute null:name documentation</h3>
   * 	The name of the method whose implementation must be replaced by the
   * 	IoC container. If this method is not overloaded, there is no need
   * 	to use arg-type subelements. If this method is overloaded, arg-type
   * 	subelements must be used for all override definitions for the method.
   *
   * </pre>
   *
   * @return the value of the name child.
   */
  @NotNull
  @Convert(value = SpringBeanReplacedMethodConverter.class)
  GenericAttributeValue<PsiMethod> getName();


  /**
   * Returns the value of the replacer child.
   * <pre>
   * <h3>Attribute null:replacer documentation</h3>
   * 	Bean name of an implementation of the MethodReplacer interface in the
   * 	current or ancestor factories. This may be a singleton or prototype
   * 	bean. If it is a prototype, a new instance will be used for each
   * 	method replacement. Singleton usage is the norm.
   *
   * </pre>
   *
   * @return the value of the replacer child.
   */
  @NotNull
  @Convert(SpringBeanResolveConverter.class)
  @RequiredBeanType(METHOD_REPLACER_CLASS)
  GenericAttributeValue<SpringBeanPointer<?>> getReplacer();


  /**
   * Returns the list of arg-type children.
   * <pre>
   * <h3>Element http://www.springframework.org/schema/beans:arg-type documentation</h3>
   * 	Identifies an argument for a replaced method in the event of
   * 	method overloading.
   *
   * </pre>
   *
   * @return the list of arg-type children.
   */
  @NotNull
  List<ArgType> getArgTypes();

  /**
   * Adds new child to the list of arg-type children.
   *
   * @return created child
   */
  ArgType addArgType();
}
