// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.util.xml.NamedEnum;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/**
 * http://www.springframework.org/schema/beans:autowireAttrType enumeration.
 */
public enum Autowire implements NamedEnum {
  AUTODETECT("autodetect"),
  BY_NAME("byName"),
  BY_TYPE("byType"),
  CONSTRUCTOR("constructor"),
  DEFAULT("default"),
  NO("no");

  private final String value;

  Autowire(@NonNls String value) {
    this.value = value;
  }

  @Override
  public String getValue() {
    return value;
  }

  public boolean isAutowired() {
    return !equals(DEFAULT) && !equals(NO);
  }

  public static Autowire fromDefault(@Nullable Autowire defaultAutowire) {
    if (defaultAutowire == null) {
      return DEFAULT;
    }

    switch (defaultAutowire) {
      case BY_NAME:
        return BY_NAME;
      case BY_TYPE:
        return BY_TYPE;
      case CONSTRUCTOR:
        return CONSTRUCTOR;
      case NO:
        return NO;
      default:
        return DEFAULT;
    }
  }
}
