// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.xml;

import org.jetbrains.annotations.NonNls;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Provides type checking for Spring bean DOM reference.
 * <p/>
 * Typical usage:
 * <pre>
 *   &#064;RequiredBeanType("com.expected.BeanType")
 *   &#064;Convert(SpringBeanResolveConverter.class)
 *   GenericAttributeValue<SpringBeanPointer<?>> getBeanRefAttribute();
 * </pre>
 * <p/>
 * Highlighting provided by {@link com.intellij.spring.model.highlighting.dom.RequiredBeanTypeChecker}
 * which is called from dedicated inspection.
 * <p/>
 * NB: in 14, usage as <em>type</em> annotation has been replaced with
 * dedicated {@link BeanType}.
 *
 * @see com.intellij.spring.model.converters.SpringBeanResolveConverter
 * @see com.intellij.spring.model.converters.SpringBeanListConverter
 * @see com.intellij.spring.model.converters.SpringConverterUtil#getRequiredBeanTypeClasses(com.intellij.util.xml.ConvertContext)
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface RequiredBeanType {

  /**
   * Possible bean type(s) FQN (usually top-most interface).
   *
   * @return Required base class(es).
   */
  @NonNls String[] value() default "UNDEFINED";
}
