/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml;

import org.jetbrains.annotations.Nullable;

/**
 * Provides dynamic (element/runtime dependent) bean name.
 *
 * @param <T> Must match {@link DomSpringBean} where {@link BeanName} is used.
 * @see BeanName
 */
public interface BeanNameProvider<T extends DomSpringBean> {

  /**
   * Determines bean name for the given instance.
   *
   * @param t DomSpringBean instance.
   * @return Bean name or {@code null} if not determinable.
   */
  @Nullable
  String getBeanName(T t);
}
