/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Highlighting provided by {@link com.intellij.spring.model.highlighting.xml.SpringIncorrectResourceTypeInspection}.
 */
public interface SpringResourceTypeProvider {
  ExtensionPointName<SpringResourceTypeProvider> EP_NAME = ExtensionPointName.create("com.intellij.spring.resourceTypeProvider");

  @Nullable
  Condition<PsiFileSystemItem> getResourceFilter(@NotNull final GenericDomValue genericDomValue);
}
