// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.values;

import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

public class PropsValueConverter extends PropertyValueConverter {
  @Override
  @NotNull
  public List<PsiType> getValueTypes(final GenericDomValue domValue) {
    final PsiType type = PsiTypeUtil.getInstance(domValue.getManager().getProject()).findType(String.class);
    return type == null ? Collections.emptyList() : Collections.singletonList(type);
  }
}
