// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model.values;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

/**
 * @author Dmitry Avdeev
 */
public class EntryKeyConverter extends PropertyValueConverter {

  @Override
  @NotNull
  public List<PsiType> getValueTypes(final GenericDomValue domValue) {
    SpringEntry entry = (SpringEntry)domValue.getParent();
    assert entry != null;
    final PsiClass psiClass = entry.getRequiredKeyClass();
    if (psiClass == null) {
      return Collections.emptyList();
    }

    final PsiClassType psiClassType = PsiTypesUtil.getClassType(psiClass);
    return Collections.singletonList(psiClassType);
  }
}
