// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model.utils.resources;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.xml.beans.SpringProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public abstract class SpringResourcesUtil {

  public static SpringResourcesUtil getInstance() {
    return ApplicationManager.getApplication().getService(SpringResourcesUtil.class);
  }

  @NotNull
  public abstract <V extends PsiFileSystemItem> Collection<V> getResourceItems(final @NotNull SpringProperty property,
                                                                               final Condition<PsiFileSystemItem> filter);

  public abstract <V extends PsiFileSystemItem> Collection<V> getResourceItems(final PsiReference[] references,
                                                                               final Condition<PsiFileSystemItem> filter);

  public abstract PsiReference[] getReferences(final @NotNull SpringResourcesBuilder builder);

  public abstract PsiReference[] getClassPathReferences(final @NotNull SpringResourcesBuilder builder);

  @Nullable
  public abstract String getResourceFileReferenceString(final PsiFile resourceFile);
}
