// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.SpringModelElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Yann C&eacute;bron
 */
public abstract class SpringModelUtils {

  public static SpringModelUtils getInstance() {
    return ApplicationManager.getApplication().getService(SpringModelUtils.class);
  }

  @NotNull
  public abstract CommonSpringModel getSpringModel(@NotNull SpringModelElement modelElement);

  @NotNull
  public abstract CommonSpringModel getSpringModel(@Nullable PsiElement element);

  @NotNull
  public abstract CommonSpringModel getPsiClassSpringModel(@NotNull PsiClass psiClass);

  @NotNull
  public abstract CommonSpringModel getModuleCombinedSpringModel(@NotNull PsiElement element);

  @NotNull
  public abstract CommonSpringModel getSpringModelByBean(@Nullable CommonSpringBean springBean);

  /**
   * Determines if given configuration file is used in test context
   *
   * @param module Module to find usages in.
   * @param file   Configuration file.
   * @return {@code true} if used in test context.
   */
  public abstract boolean isTestContext(Module module, PsiFile file);

  /**
   * Determines whether given configuration file is used explicitly (fileset) or
   * implicitly (e.g. included) in any Spring model in its module (or dependent modules).
   *
   * @param configurationFile Configuration file.
   * @param checkTestFiles    Whether to check configuration files used in test contexts.
   * @return {@code true} if file is used. {@code false} in dumb mode or if file is not used.
   */
  public abstract boolean isUsedConfigurationFile(@NotNull PsiFile configurationFile, boolean checkTestFiles);

  public  abstract boolean hasAutoConfiguredModels(@Nullable Module module);
}
