// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author Yann C&eacute;bron
 */
public abstract class PsiTypeUtil {

  public static PsiTypeUtil getInstance(Project project) {
    return project.getService(PsiTypeUtil.class);
  }

  @Nullable
  public abstract PsiType findType(@NotNull Class<?> aClass);

  public abstract boolean isCollectionType(@NotNull PsiType psiType);

  public abstract boolean isConvertable(@NotNull PsiType from, @NotNull List<? extends PsiType> types);
}
