// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class SpringTestingImplicitContextsProvider {
  public static final ExtensionPointName<SpringTestingImplicitContextsProvider> EP_NAME =
    new ExtensionPointName<>("com.intellij.spring.testingImplicitContextsProvider");

  @NotNull
  public abstract Collection<CommonSpringModel> getModels(@Nullable Module module,
                                                          @NotNull ContextConfiguration configuration,
                                                          @NotNull Set<String> activeProfiles);

  protected static boolean isAnnotated(@NotNull ContextConfiguration configuration,
                                       @Nullable Module module,
                                       @NotNull String annotation) {
    if (module == null) return false;

    List<String> annotations = ContainerUtil
      .mapNotNull(JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildrenIncludingTests(annotation),
                  PsiClass::getQualifiedName);

    return AnnotationUtil.isAnnotated(configuration.getPsiElement(), annotations, 0);
  }
}