/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public abstract class SpringPropertySources implements JamElement {
  public static final JamAnnotationAttributeMeta.Collection<SpringJamPropertySource> VALUE_ATTRIBUTE =
    JamAttributeMeta.annoCollection("value", SpringJamPropertySource.ANNO_META, SpringJamPropertySource.class);

  public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta(SpringAnnotationsConstants.PROPERTY_SOURCES).addAttribute(
    VALUE_ATTRIBUTE);

  public static final JamClassMeta<SpringPropertySources> META = new JamClassMeta<>(SpringPropertySources.class).addAnnotation(ANNO_META);

  private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
  private final PsiClass myPsiClass;

  public SpringPropertySources(@NotNull PsiClass psiClass) {
    myPsiClass = psiClass;
    myPsiAnnotation = ANNO_META.getAnnotationRef(psiClass);
  }

  public SpringPropertySources(@NotNull PsiAnnotation annotation) {
    myPsiClass = PsiTreeUtil.getParentOfType(annotation, PsiClass.class, true);
    myPsiAnnotation = PsiElementRef.real(annotation);
  }
  @NotNull
  public PsiClass getPsiElement() {
    return myPsiClass;
  }

  @JamPsiValidity
  public abstract boolean isPsiValid();

  @NotNull
  public List<SpringJamPropertySource> getPropertySources() {
    return JamCommonUtil.getElementsIncludingSingle(getPsiElement(), ANNO_META, VALUE_ATTRIBUTE);
  }
}
