// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiNamedElement;
import com.intellij.spring.model.jam.JamPsiMethodSpringBean;

public abstract class SpringJavaBean extends JamPsiMethodSpringBean {

  @Override
  public PsiNamedElement getIdentifyingPsiElement() {
    return getPsiElement();
  }

  public abstract PsiAnnotation getPsiAnnotation();

  public boolean isPublic() {
    return getPsiElement().getModifierList().hasModifierProperty(PsiModifier.PUBLIC);
  }
}
