// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;

import java.util.List;

@Deprecated
public abstract class JavaConfigJavaBean extends SpringJavaBean {
  private static final JamStringAttributeMeta.Collection<String> ALIASES_META = JamAttributeMeta.collectionString("aliases");

  public static final JamAnnotationMeta META =
    new JamAnnotationMeta(SpringAnnotationsConstants.JAVA_CONFIG_BEAN).addAttribute(ALIASES_META);

  @Override
  public PsiAnnotation getPsiAnnotation() {
    return META.getAnnotation(getPsiElement());
  }

  @Override
  public String @NotNull [] getAliases() {
    List<String> aliases = getStringNames(META.getAttribute(getPsiElement(), ALIASES_META));

    return ArrayUtilRt.toStringArray(aliases);
  }
}