/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.*;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Collections;

public class PackageListJamConverter extends JamConverter<Collection<PsiPackage>> {

  @Override
  public Collection<PsiPackage> fromString(@Nullable String s,
                                           JamStringAttributeElement<Collection<PsiPackage>> context) {
    PsiLanguageInjectionHost host = context.getLanguageInjectionHost();
    if (host == null || StringUtil.isEmptyOrSpaces(s)) return Collections.emptyList();

    if (SpringConverterUtil.containsPatternReferences(s)) {
      return SpringConverterUtil.getPsiPackages(createReferences(context, host));
    }

    return SpringConverterUtil.getPackages(s, context.getPsiManager().getProject());
  }

  @Override
  public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<Collection<PsiPackage>> context,
                                                   @NotNull PsiLanguageInjectionHost injectionHost) {
    return SpringReferenceUtils.getPsiPackagesReferences(injectionHost,
                                                         context.getStringValue(),
                                                         ElementManipulators.getOffsetInElement(injectionHost));
  }
}
