// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model.jam;

import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamPsiClassSpringBean extends JamPsiMemberSpringBean<PsiClass> {

  @Override
  @NotNull
  @JamPsiConnector
  public abstract PsiClass getPsiElement();

  @Override
  @JamPsiValidity
  public abstract boolean isValid();

  @Override
  @Nullable
  public String getBeanName() {
    if (!isValid()) return null;

    return StringUtil.decapitalize(StringUtil.notNullize(getPsiElement().getName()));
  }

  @Override
  @Nullable
  public PsiType getBeanType() {
    if (!isValid()) return null;

    return PsiTypesUtil.getClassType(getPsiElement());
  }
}