// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.xmlb.annotations.Attribute;

/**
 * Allows to override specific meta-annotation's (and its meta-annotations) JAM implementation provided by Spring plugin.
 */
public final class JamCustomImplementationBean {
  static final ExtensionPointName<JamCustomImplementationBean> EP_NAME =
    new ExtensionPointName<>("com.intellij.spring.jam.customMetaImplementation");

  /**
   * Base annotation, e.g. {@code ContextConfiguration}
   */
  @Attribute("baseAnnotationFqn")
  public String baseAnnotationFqn;

  /**
   * Meta-annotation base class requiring custom JAM implementation, e.g. {@code SpringApplicationConfiguration}
   */
  @Attribute("customMetaAnnotationFqn")
  public String customMetaAnnotationFqn;
}
