// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.highlighting.jam

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool
import com.intellij.codeInspection.ProblemsHolder
import com.intellij.openapi.module.Module
import com.intellij.openapi.module.ModuleUtilCore
import com.intellij.psi.PsiElementVisitor
import com.intellij.spring.SpringLibraryUtil
import org.jetbrains.uast.UElement
import kotlin.reflect.KClass

abstract class SpringUastInspectionBase : AbstractBaseUastLocalInspectionTool {
  constructor() : super()
  constructor(vararg uElementTypesHint: Class<out UElement>) : super(*uElementTypesHint)
  constructor(vararg uElementTypesHint: KClass<out UElement>) : super(*uElementTypesHint.map { h -> h.java }.toTypedArray())

  final override fun buildVisitor(holder: ProblemsHolder, isOnTheFly: Boolean): PsiElementVisitor {
    if (!isEnabledForModule(ModuleUtilCore.findModuleForFile(holder.file))) return PsiElementVisitor.EMPTY_VISITOR

    return super.buildVisitor(holder, isOnTheFly)
  }

  open fun isEnabledForModule(module: Module?) = SpringLibraryUtil.hasSpringLibrary(module)

}
