// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.spring.SpringLibraryUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SpringJavaInspectionBase extends AbstractBaseJavaLocalInspectionTool {
  @Override
  public @NotNull PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
    if (!SpringLibraryUtil.hasSpringLibrary(ModuleUtilCore.findModuleForFile(holder.getFile()))) {
      return PsiElementVisitor.EMPTY_VISITOR;
    }

    return super.buildVisitor(holder, isOnTheFly);
  }
}
