// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.custom;

import com.intellij.openapi.module.Module;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomComponentDiscovererBeansModel extends CacheableCommonSpringModel {

  private final Module myModule;
  @NotNull private final String myProviderName;

  public CustomComponentDiscovererBeansModel(@Nullable Module module, @NotNull String providerName) {
    myModule = module;
    myProviderName = providerName;
  }

  @Override
  public String toString() {
    return myProviderName + ": " + super.toString();
  }

  @Override
  public @Nullable Module getModule() {
    return myModule;
  }

}
