// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.PsiClassConverter;

/**
 * @author Dmitry Avdeev
 */
public class SpringDomQualifierTypeConverter extends PsiClassConverter {

  @Override
  public PsiClass fromString(final String s, final ConvertContext context) {
    if (s == null) {
      return DomJavaUtil.findClass(SpringAnnotationsConstants.QUALIFIER,
                                   context.getFile(), context.getModule(), null);
    }
    return super.fromString(s, context);
  }
}
