/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.converters;

import com.intellij.spring.model.xml.context.Filter;
import com.intellij.spring.model.xml.context.Type;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

public class SpringContextFilterExpressionConverter extends WrappingConverter {
  private static final PsiClassConverter myClassConverter = new PsiClassConverter();
  private static final PsiClassConverter myAnnotationTypeClassConverter = new PsiClassConverter.AnnotationType();

  @Override
  public Converter getConverter(@NotNull GenericDomValue domElement) {
    final Filter filter = domElement.getParentOfType(Filter.class, true);
    if (filter != null) {
      final Type type = filter.getType().getValue();

      if (type != null) {
        if (type.equals(Type.ANNOTATION)) {
          return myAnnotationTypeClassConverter;
        }
        else if (type.equals(Type.ASSIGNABLE)) {
          return myClassConverter;
        }
      }
    }
    return null;
  }
}
