// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.converters;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.Nullable;

public class CustomConverterRegistry {

  public interface Provider extends Condition<GenericDomValue> {

    ExtensionPointName<Provider> EXTENSION_POINT_NAME = ExtensionPointName.create("com.intellij.spring.customConverterProvider");

    Converter getConverter();

    Class getConverterClass();
  }

  public static CustomConverterRegistry getRegistry() {
    return ourInstance;
  }

  private final static CustomConverterRegistry ourInstance = new CustomConverterRegistry();

  @Nullable
  public Converter<?> getCustomConverter(Class aClass, GenericDomValue context) {
    for (Provider provider : Provider.EXTENSION_POINT_NAME.getExtensionList()) {
      if(aClass.equals(provider.getConverterClass()) && provider.value(context)) return provider.getConverter();
    }
    return null;
  }
}
