// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.cacheable;

import org.jetbrains.annotations.NonNls;

public interface SpringCacheableConstants {
  // annotations
  @NonNls String CACHEABLE = "org.springframework.cache.annotation.Cacheable";
  @NonNls String CACHE_EVICT = "org.springframework.cache.annotation.CacheEvict";
  @NonNls String CACHE_PUT = "org.springframework.cache.annotation.CachePut";
  @NonNls String CACHE_CONFIG = "org.springframework.cache.annotation.CacheConfig";
  @NonNls String ENABLE_CACHING = "org.springframework.cache.annotation.EnableCaching";

  @NonNls String CACHING = "org.springframework.cache.annotation.Caching";

  // classes
  @NonNls String KEY_GENERATOR_CLASS = "org.springframework.cache.interceptor.KeyGenerator";
  @NonNls String CACHE_MANAGER_CLASS = "org.springframework.cache.CacheManager";
  @NonNls String CACHE_RESOLVER_CLASS = "org.springframework.cache.interceptor.CacheResolver";

  @NonNls String ROOT_OBJECT_CLASS = "org.springframework.cache.interceptor.CacheExpressionRootObject";
  @NonNls String GENERIC_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.GenericCacheConfiguration";
  @NonNls String ELCACHE_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.EhCacheCacheConfiguration";
  @NonNls String HAZELCAST_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.HazelcastCacheConfiguration";
  @NonNls String INFINISPAN_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.InfinispanCacheConfiguration";
  @NonNls String JCACHE_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.JCacheCacheConfiguration";
  @NonNls String COUCHBASE_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.CouchbaseCacheConfiguration";
  @NonNls String REDIS_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.RedisCacheConfiguration";
  @NonNls String CAFFEINE_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.CaffeineCacheConfiguration";
  @NonNls String SIMPLE_CACHE_CONFIGURATION = "org.springframework.boot.autoconfigure.cache.SimpleCacheConfiguration";

  @NonNls String CACHE_CLASSNAME = "org.springframework.cache.Cache";
  @NonNls String HAZELCAST_CACHE_MANAGER = "com.hazelcast.spring.cache.HazelcastCacheManager";
  @NonNls String SPRING_EMBEDDED_CACHE_MANAGER = "org.infinispan.spring.provider.SpringEmbeddedCacheManager";
  @NonNls String JCACHE_CACHE_MANAGER = "org.springframework.cache.jcache.JCacheCacheManager";
  @NonNls String COUCHBASE_CACHE_MANAGER = "com.couchbase.client.spring.cache.CouchbaseCacheManager";
  @NonNls String REDIS_CACHE_MANAGER = "org.springframework.data.redis.cache.RedisCacheManager";
  @NonNls String CAFFEINE_CLASSNAME = "com.github.benmanes.caffeine.cache.Caffeine";
  @NonNls String CACHE_CONFIGURATION_IMPORT_SELECTOR =
    "org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration.CacheConfigurationImportSelector";
}
