// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions.patterns.frameworks.util;

import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.net.URL;
import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class StandardBeansDocLinksManager {

  @NotNull
  public static StandardBeansDocLinksManager getInstance() {
    return ApplicationManager.getApplication().getService(StandardBeansDocLinksManager.class);
  }

  protected abstract Set<URL> getDocLinkResources();

  @Nullable
  public abstract String getApiLink(String beanId);

  @Nullable
  public abstract String getReferenceLink(String beanId);
}
