// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions.patterns.frameworks.util;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Yann C&eacute;bron
 */
public abstract class LibrariesConfigurationManager {
  @NotNull
  public static LibrariesConfigurationManager getInstance(@NotNull Project project) {
    return project.getService(LibrariesConfigurationManager.class);
  }

  public abstract LibraryInfo @Nullable [] getLibraryInfos(String frameworkId);
}
