// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public abstract class AbstractFrameworkSupportProvider implements FrameworkSupportProvider {

  @Override
  public Map<String, String> getPredefinedVars(@NotNull Module module, XmlFile xmlFile) {
    return FrameworkSupportTemplatesRunner.getInstance().getPredefinedVars(module, xmlFile);
  }

  @Override
  public void addFacet(Module module) {
  }
}
