// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.facet.*;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public abstract class AbstractFrameworkIntegrationAction extends FrameworkIntegrationAction {

  @Override
  protected void generateSpringBeans(final Module module, final Editor editor, final XmlFile xmlFile) {
    FrameworkSupportTemplatesRunner.getInstance().generateSpringBeans(this, module, editor, xmlFile);
  }

  @Override
  @NotNull
  public Map<String, String> getPredefinedVars(@NotNull Module module, XmlFile xmlFile) {
    return FrameworkSupportTemplatesRunner.getInstance().getPredefinedVars(module, xmlFile);
  }

  @Override
  public void addFacet(final Module module) {
    if (module == null) return;

    final String facetId = getFacetId();
    if (!StringUtil.isEmptyOrSpaces(facetId)) {

      final FacetManager facetManager = FacetManager.getInstance(module);
      final FacetType<?, ?> type = FacetTypeRegistry.getInstance().findFacetType(facetId);

      if (type != null) {

        if (facetManager.getFacetByType(type.getId()) == null) {
          final ModifiableFacetModel model = facetManager.createModifiableModel();

          final Facet facet = facetManager.addFacet(type, type.getDefaultFacetName(), null);

          model.addFacet(facet);
          model.commit();
        }
      }
    }
  }

  @Nullable
  protected String getFacetId() {
    return null;
  }
}
