// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model;

import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.Nullable;

public interface SpringInheritableQualifier extends SpringQualifier {
  @Override
  default boolean compareQualifiers(@Nullable final SpringQualifier other, @Nullable Module module) {
    return SpringQualifierComparator.compareQualifiers(this, other) ||
           SpringQualifierComparator.compareInheritorQualifier(this, other, module) ||
           SpringQualifierComparator.compareInheritorQualifier(other, this, module);
  }
}
