// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author Dmitry Avdeev
 */
public interface ResolvedConstructorArgs {

  boolean isResolved();

  @Nullable
  PsiMethod getResolvedMethod();

  @NotNull
  List<PsiMethod> getCheckedMethods();

  /**
   * @return null if {@link #getResolvedMethod()} returns null.
   */
  @Nullable
  Map<ConstructorArgDefinition, PsiParameter> getResolvedArgs();

  @Nullable
  Map<ConstructorArgDefinition, PsiParameter> getResolvedArgs(@NotNull PsiMethod method);

  @Nullable
  Map<PsiParameter, Collection<SpringBeanPointer<?>>> getAutowiredParams(@NotNull PsiMethod method);

  List<PsiMethod> getCandidates();
}
