// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model;

import com.intellij.openapi.util.Comparing;
import it.unimi.dsi.fastutil.Hash;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

/**
 * @author Dmitry Avdeev
 */
public interface QualifierAttribute {
  @Nullable
  String getAttributeKey();

  @Nullable
  Object getAttributeValue();

  Hash.Strategy<QualifierAttribute> HASHING_STRATEGY = new Hash.Strategy<>() {
    @Override
    public int hashCode(final QualifierAttribute object) {
      if (object == null) {
        return 0;
      }

      final String key = object.getAttributeKey();
      final Object value = object.getAttributeValue();
      return (key == null ? 0 : key.hashCode()) + (value == null ? 0 : value.hashCode());
    }

    @Override
    public boolean equals(final QualifierAttribute o1, final QualifierAttribute o2) {
      return o1 == o2 ||
             (o1 != null &&
              o2 != null &&
              Objects.equals(o1.getAttributeKey(), o2.getAttributeKey()) &&
              Comparing.equal(o1.getAttributeValue(), o2.getAttributeValue()));
    }
  };
}
