// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

public final class DefaultSpringBeanQualifier implements SpringQualifier {

  public static DefaultSpringBeanQualifier create(@NotNull CommonSpringBean bean) {
    return new DefaultSpringBeanQualifier(bean);
  }

  private final CommonSpringBean myBean;

  private DefaultSpringBeanQualifier(@NotNull CommonSpringBean bean) {
    myBean = bean;
  }

  @Override
  public boolean isValid() {
    return myBean.isValid();
  }

  @Override
  public XmlTag getXmlTag() {
    return null;
  }

  @Override
  public PsiManager getPsiManager() {
    return myBean.getPsiManager();
  }

  @Override
  public Module getModule() {
    return myBean.getModule();
  }

  @NotNull
  @Override
  public PsiElement getIdentifyingPsiElement() {
    final PsiElement psiElement = myBean.getIdentifyingPsiElement();
    assert psiElement != null : myBean;
    return psiElement;
  }

  @Override
  public PsiFile getContainingFile() {
    return myBean.getContainingFile();
  }

  @Override
  public PsiClass getQualifierType() {
    return null;
  }

  @Override
  public String getQualifierValue() {
    return myBean.getBeanName();
  }

  @NotNull
  @Override
  public List<? extends QualifierAttribute> getQualifierAttributes() {
    return Collections.emptyList();
  }
}
