// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class BeanService {

  public static BeanService getInstance() {
    return ApplicationManager.getApplication().getService(BeanService.class);
  }

  /**
   * @return bean effective types
   *  1. if bean is factory bean: bean type AND product type will be collected
   *  2. if factory product proxies multiple interfaces all multiple values(types) will be collected
   * @see SpringBeanEffectiveTypeProvider
   * @see SpringBeanPointer#getEffectiveBeanTypes()
   */
  public abstract PsiType @NotNull [] getEffectiveBeanTypes(@NotNull final CommonSpringBean bean);

  @NotNull
  public abstract SpringBeanPointer<?> createSpringBeanPointer(@NotNull final CommonSpringBean springBean);

  /**
   * @param springBean only {@link com.intellij.spring.model.xml.DomSpringBean}
   * @return target instance
   */
  @NotNull
  public abstract SpringBeanPsiTarget createSpringBeanPsiTarget(@NotNull final CommonSpringBean springBean);

  /**
   * @see SpringBeanPointer#TO_BEAN
   */
  @NotNull
  public abstract Set<SpringBeanPointer<?>> mapSpringBeans(@NotNull Collection<? extends CommonSpringBean> beans);
}
