// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.gutter.groups;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ConstantFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.Collection;
import java.util.List;

import static com.intellij.spring.gutter.groups.SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT;

public class SpringRelatedMergeableLineMarkerInfo extends RelatedItemLineMarkerInfo<PsiElement> {
  private @Nullable String myElementPresentation;

  private SpringRelatedMergeableLineMarkerInfo(@NotNull PsiElement element,
                                               @NotNull Icon icon,
                                               @NotNull String tooltip,
                                               @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                               @NotNull NotNullFactory<? extends Collection<GotoRelatedItem>> targets) {
    super(element, element.getTextRange(), icon,
          new ConstantFunction<>(tooltip),
          navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT, targets);
  }

  SpringRelatedMergeableLineMarkerInfo(@NotNull PsiElement element,
                                       NavigationGutterIconRenderer renderer,
                                       @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                       @NotNull NotNullFactory<? extends Collection<GotoRelatedItem>> targets) {
    super(element, element.getTextRange(), renderer.getIcon(),
          renderer.getTooltipText() == null ? null : new ConstantFunction<>(renderer.getTooltipText()),
          navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT,
          targets);
  }

  SpringRelatedMergeableLineMarkerInfo(@NotNull PsiElement element,
                                       @NotNull Icon icon,
                                       @NotNull String tooltip,
                                       @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                       @NotNull NotNullFactory<? extends Collection<GotoRelatedItem>> targets,
                                       @Nullable String elementPresentation) {
    this(element, icon, tooltip, navHandler, targets);
    myElementPresentation = elementPresentation;
  }

  @Override
  public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
    return DEFAULT_GUTTER_ICON_ALIGNMENT;
  }

  @Override
  public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
    Icon itemIcon = super.getCommonIcon(infos);
    LayeredIcon icon = JBUIScale.scaleIcon(new LayeredIcon(2));
    icon.setIcon(itemIcon, 0, 0, 0);
    icon.setIcon(AllIcons.General.DropdownGutter, 1, 0, 0);
    return icon;
  }

  @Override
  public @NotNull String getElementPresentation(@NotNull PsiElement element) {
    return myElementPresentation != null ? myElementPresentation : super.getElementPresentation(element);
  }
}
