// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.contexts.model.graph;

import com.intellij.openapi.module.Module;
import com.intellij.spring.contexts.model.LocalModel;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

public abstract class AbstractModelDependenciesGraph extends LazyDependenciesGraph<LocalModel<?>, LocalModelDependency> {
  @NotNull private final Module myModule;
  @NotNull private final Set<String> myProfiles;

  protected AbstractModelDependenciesGraph(@NotNull Module module, @NotNull Set<String> profiles) {
    myModule = module;
    myProfiles = profiles;
  }

  @NotNull
  public Module getModule() {
    return myModule;
  }

  @NotNull
  public Set<String> getProfiles() {
    return myProfiles;
  }
}
