// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import static com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext.context;
import static com.intellij.spring.contexts.model.visitors.SpringModelVisitors.visitRelatedModels;

public abstract class AbstractProcessableModel extends UserDataHolderBase implements CommonSpringModel {

  @Override
  public boolean processByClass(@NotNull final SpringModelSearchParameters.BeanClass params,
                                @NotNull Processor<? super SpringBeanPointer<?>> processor) {
    if (!params.canSearch()) return true;
    return visitRelatedModels(this, context(processor, (model, p) -> model.processByClass(params, p)), false);
  }


  @Override
  public boolean processByName(@NotNull final SpringModelSearchParameters.BeanName params,
                               @NotNull Processor<? super SpringBeanPointer<?>> processor) {
    if (!params.canSearch()) return true;
    return visitRelatedModels(this, context(processor, (m, p) -> m.processByName(params, p)), false);
  }

  @Override
  @NotNull
  public Collection<SpringBeanPointer<?>> getAllCommonBeans() {
    final Set<SpringBeanPointer<?>> pointers = new LinkedHashSet<>();
    processAllBeans(Processors.cancelableCollectProcessor(pointers));
    return Collections.unmodifiableSet(pointers);
  }


  @Override
  public boolean processAllBeans(@NotNull Processor<? super SpringBeanPointer<?>> processor) {
    return visitRelatedModels(this, context(processor, (m, p) -> m.processAllBeans(p)), false);
  }
}
