// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.constants;

import com.intellij.psi.CommonClassNames;
import org.jetbrains.annotations.NonNls;

import java.util.List;

import static com.intellij.util.containers.ContainerUtil.immutableList;

public interface SpringConstants {

  @NonNls String AOP_NAMESPACE = "http://www.springframework.org/schema/aop";
  @NonNls String JEE_NAMESPACE = "http://www.springframework.org/schema/jee";
  @NonNls String LANG_NAMESPACE = "http://www.springframework.org/schema/lang";
  @NonNls String TOOL_NAMESPACE = "http://www.springframework.org/schema/tool";
  @NonNls String TX_NAMESPACE = "http://www.springframework.org/schema/tx";
  @NonNls String UTIL_NAMESPACE = "http://www.springframework.org/schema/util";
  @NonNls String CONTEXT_NAMESPACE = "http://www.springframework.org/schema/context";
  @NonNls String CACHE_NAMESPACE = "http://www.springframework.org/schema/cache";
  @NonNls String P_NAMESPACE = "http://www.springframework.org/schema/p";
  @NonNls String C_NAMESPACE = "http://www.springframework.org/schema/c";
  @NonNls String TASK_NAMESPACE = "http://www.springframework.org/schema/task";
  @NonNls String JDBC_NAMESPACE = "http://www.springframework.org/schema/jdbc";

  @NonNls String BEANS_XSD = "http://www.springframework.org/schema/beans";

  @NonNls String BEANS_DTD_1 = "http://www.springframework.org/dtd/spring-beans.dtd";
  @NonNls String BEANS_DTD_2 = "http://www.springframework.org/dtd/spring-beans-2.0.dtd";
  @NonNls String BEANS_NAMESPACE_KEY = "Spring beans namespace key";

  @NonNls String AOP_NAMESPACE_KEY = "Spring AOP namespace key";
  @NonNls String JEE_NAMESPACE_KEY = "Spring JEE namespace key";
  @NonNls String LANG_NAMESPACE_KEY = "Spring Lang namespace key";
  @NonNls String TX_NAMESPACE_KEY = "Spring TX namespace key";
  @NonNls String UTIL_NAMESPACE_KEY = "Spring Util namespace key";
  @NonNls String CONTEXT_NAMESPACE_KEY = "Spring Context namespace key";
  @NonNls String CACHE_NAMESPACE_KEY = "Spring Cache namespace key";
  @NonNls String P_NAMESPACE_KEY = "Spring p-namespace";
  @NonNls String C_NAMESPACE_KEY = "Spring c-namespace";
  @NonNls String TASK_NAMESPACE_KEY = "Spring task namespace key";
  @NonNls String JDBC_NAMESPACE_KEY = "Spring JDBC namespace key";

  @NonNls String SPRING_VERSION_CLASS = "org.springframework.core.SpringVersion";

  @NonNls String ASPECTJ_AUTOPROXY = "aspectj-autoproxy";
  @NonNls String ASPECTJ_AUTOPROXY_BEAN_CLASS = "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator";
  @NonNls String AOP_ALLIANCE_ADVICE_CLASS = "org.aopalliance.aop.Advice";

  @NonNls String BEAN_FACTORY_CLASS = "org.springframework.beans.factory.BeanFactory";
  @NonNls String OBJECT_FACTORY_CLASS = "org.springframework.beans.factory.ObjectFactory";
  @NonNls String BEAN_FACTORY_AWARE = "org.springframework.beans.factory.BeanFactoryAware";
  @NonNls String BEAN_FACTORY_POST_PROCESSOR = "org.springframework.beans.factory.config.BeanFactoryPostProcessor";
  @NonNls String CONFIGURABLE_BEAN_FACTORY = "org.springframework.beans.factory.config.ConfigurableBeanFactory";
  @NonNls String CONFIGURABLE_LISTABLE_BEAN_FACTORY = "org.springframework.beans.factory.config.ConfigurableListableBeanFactory";
  @NonNls String METHOD_INVOKING_FACTORY_BEAN_CLASS = "org.springframework.beans.factory.config.MethodInvokingFactoryBean";
  @NonNls String JNDI_OBJECT_FACTORY_BEAN = "org.springframework.jndi.JndiObjectFactoryBean";
  @NonNls String MAP_FACTORY_BEAN = "org.springframework.beans.factory.config.MapFactoryBean";
  @NonNls String BEAN_NAME_GENERATOR = "org.springframework.beans.factory.support.BeanNameGenerator";

  @NonNls String CLASS_PATH_XML_APP_CONTEXT = "org.springframework.context.support.ClassPathXmlApplicationContext";
  @NonNls String IO_RESOURCE = "org.springframework.core.io.Resource";
  @NonNls String CLASS_PATH_RESOURCE = "org.springframework.core.io.ClassPathResource";
  @NonNls String AUTOWIRED_ANNO_POST_PROCESSOR_CLASS = "org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor";

  @NonNls String ANNOTATION_CONFIG_APPLICATION_CONTEXT = "org.springframework.context.annotation.AnnotationConfigApplicationContext";

  @NonNls String SCOPE_METADATA_RESOLVER = "org.springframework.context.annotation.ScopeMetadataResolver";
  @NonNls String ANNOTATION_SCOPE_METADATA_RESOLVER = "org.springframework.context.annotation.AnnotationScopeMetadataResolver";

  @NonNls String CUSTOM_EDITOR_CONFIGURER_CLASS = "org.springframework.beans.factory.config.CustomEditorConfigurer";
  @NonNls String CONFIGURABLE_ENVIRONMENT = "org.springframework.core.env.ConfigurableEnvironment";
  @NonNls String ENVIRONMENT_CLASS = "org.springframework.core.env.Environment";
  @NonNls String PROPERTY_RESOLVER_CLASS = "org.springframework.core.env.PropertyResolver";
  @NonNls String CONVERSION_SERVICE_CLASS = "org.springframework.core.convert.ConversionService";

  @NonNls String SPRING_BEAN_AUTOWIRING_SUPPORT_CLASS = "org.springframework.web.context.support.SpringBeanAutowiringSupport";

  @NonNls String PROPERTY_OVERRIDE_CONFIGURER = "org.springframework.beans.factory.config.PropertyOverrideConfigurer";
  @NonNls String PROPERTIES_FACTORY_BEAN = "org.springframework.beans.factory.config.PropertiesFactoryBean";
  @NonNls String PROPERTIES_LOADER_SUPPORT = "org.springframework.core.io.support.PropertiesLoaderSupport";

  @NonNls String JAVAX_SQL_DATA_SOURCE = "javax.sql.DataSource";

  @NonNls String SPRING_UTIL_CONCURRENT_LISTENABLE_FUTURE = "org.springframework.util.concurrent.ListenableFuture";
  @NonNls String JAVA_UTIL_CONCURRENT_COMPLETABLE_FUTURE = CommonClassNames.JAVA_UTIL_CONCURRENT_COMPLETABLE_FUTURE;

  @NonNls String SPRING_ASYNC_RESULT = "org.springframework.scheduling.annotation.AsyncResult";

  // JSR-330
  @NonNls String JAVAX_INJECT_PROVIDER_CLASS = "javax.inject.Provider";
  @NonNls String JAKARTA_INJECT_PROVIDER_CLASS = "jakarta.inject.Provider";

  @NonNls String FACTORY_BEAN = "org.springframework.beans.factory.FactoryBean";

  @NonNls String CACHE_MANAGER = "org.springframework.cache.CacheManager";

  // spring 4.2
  @NonNls String APPLICATION_EVENT_PUBLISHER = "org.springframework.context.ApplicationEventPublisher";
  @NonNls String APPLICATION_LISTENER = "org.springframework.context.ApplicationListener";
  @NonNls String ON_APPLICATION_EVENT_METHOD = "onApplicationEvent";
  @NonNls String APPLICATION_EVENT = "org.springframework.context.ApplicationEvent";
  @NonNls String APPLICATION_EVENT_SHORT_NAME = "ApplicationEvent";

  @NonNls String MESSAGE_SOURCE = "org.springframework.context.MessageSource";
  @NonNls String APPLICATION_CONTEXT = "org.springframework.context.ApplicationContext";
  @NonNls String RESOURCE_LOADER = "org.springframework.core.io.ResourceLoader";

  @NonNls String INJECTION_POINT = "org.springframework.beans.factory.InjectionPoint";

  //JSR-303
  @NonNls String CONSTRAINT_VALIDATOR = "javax.validation.ConstraintValidator";

  @NonNls String DATA_SIZE = "org.springframework.util.unit.DataSize";
  @NonNls String DATA_UNIT = "org.springframework.util.unit.DataUnit";

  @NonNls List<String> EVENT_WRAPPER_CLASSES = immutableList(
    CommonClassNames.JAVA_UTIL_COLLECTION,
    CommonClassNames.JAVA_UTIL_LIST,
    CommonClassNames.JAVA_UTIL_SET
  );

  // spring 5.2 reactive event wrappers, should have single <T> type parameter
  @NonNls List<String> REACTIVE_EVENT_WRAPPER_CLASSES = immutableList(
    CommonClassNames.JAVA_UTIL_CONCURRENT_COMPLETION_STAGE,
    JAVA_UTIL_CONCURRENT_COMPLETABLE_FUTURE,
    SPRING_UTIL_CONCURRENT_LISTENABLE_FUTURE,
    "org.springframework.util.concurrent.ListenableFutureTask"
  );
}
