// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.constants;

import org.jetbrains.annotations.NonNls;

/**
 * @author Sergey Vasiliev
 */
public interface SpringAnnotationsConstants {
  // java config
  @Deprecated
  @NonNls String JAVA_CONFIG_CONFIGURATION = "org.springframework.config.java.annotation.Configuration";
  @Deprecated
  @NonNls String JAVA_CONFIG_BEAN = "org.springframework.config.java.annotation.Bean";
  @Deprecated
  @NonNls String JAVA_CONFIG_EXTERNAL_BEAN = "org.springframework.config.java.annotation.ExternalBean";

  // java config in spring 3.0
  @NonNls String JAVA_SPRING_CONFIGURATION = "org.springframework.context.annotation.Configuration";
  @NonNls String JAVA_SPRING_BEAN = "org.springframework.context.annotation.Bean";

  @NonNls String CONTEXT_IMPORT = "org.springframework.context.annotation.Import";
  @NonNls String CONTEXT_IMPORT_RESOURCE = "org.springframework.context.annotation.ImportResource";

  @NonNls String SCOPE = "org.springframework.context.annotation.Scope";

  @NonNls String PRIMARY = "org.springframework.context.annotation.Primary";
  @NonNls String ORDER = "org.springframework.core.annotation.Order";

  @NonNls String CONDITIONAL = "org.springframework.context.annotation.Conditional";
  @NonNls String CONDITION = "org.springframework.context.annotation.Condition";

  // stereotypes
  @NonNls String COMPONENT = "org.springframework.stereotype.Component";
  @NonNls String CONTROLLER = "org.springframework.stereotype.Controller";
  @NonNls String REPOSITORY = "org.springframework.stereotype.Repository";
  @NonNls String SERVICE = "org.springframework.stereotype.Service";

  // autowired annotations
  @NonNls String AUTOWIRED = "org.springframework.beans.factory.annotation.Autowired";
  @NonNls String INJECT = "javax.inject.Inject"; // spring 3.0 support for JSR-330
  @NonNls String NAMED = "javax.inject.Named"; // spring 3.0 support for JSR-330
  @NonNls String JAVAX_INJECT_QUALIFIER = "javax.inject.Qualifier"; // spring 3.0 support for JSR-330
  @NonNls String VALUE = "org.springframework.beans.factory.annotation.Value";

  // spring 3.1
  @NonNls String PROFILE = "org.springframework.context.annotation.Profile";
  @NonNls String COMPONENT_SCAN = "org.springframework.context.annotation.ComponentScan";
  @NonNls String COMPONENT_SCAN_FILTER = "org.springframework.context.annotation.ComponentScan.Filter";
  @NonNls String COMPONENT_SCAN_FILTER_TYPE = "org.springframework.context.annotation.FilterType";
  @NonNls String ACTIVE_PROFILES = "org.springframework.test.context.ActiveProfiles";
  @NonNls String PROPERTY_SOURCE = "org.springframework.context.annotation.PropertySource";
  @NonNls String PROPERTY_SOURCES = "org.springframework.context.annotation.PropertySources";

  // Spring 4.x
  @NonNls String CONTEXT_DESCRIPTION = "org.springframework.context.annotation.Description";

  // Spring 4.2
  @NonNls String EVENT_LISTENER = "org.springframework.context.event.EventListener";
  @NonNls String TRANSACTIONAL_EVENT_LISTENER = "org.springframework.transaction.event.TransactionalEventListener";
  @NonNls String ROOT_OBJECT_CLASS = "org.springframework.context.event.EventExpressionRootObject";
  @NonNls String ALIAS_FOR = "org.springframework.core.annotation.AliasFor";

  // Spring 4.3
  @NonNls String COMPONENT_SCANS = "org.springframework.context.annotation.ComponentScans";

  // spring 2.X
  @NonNls String CONFIGURABLE = "org.springframework.beans.factory.annotation.Configurable";
  @NonNls String QUALIFIER = "org.springframework.beans.factory.annotation.Qualifier";
  @NonNls String REQUIRED = "org.springframework.beans.factory.annotation.Required";

  @NonNls String NULLABLE = "org.springframework.lang.Nullable";

  // javax annotations
  @NonNls String JAVAX_MANAGED_BEAN = "javax.annotation.ManagedBean";
  @NonNls String JAVAX_RESOURCE = "javax.annotation.Resource";

  @NonNls String CUSTOM_AUTOWIRE_CONFIGURER_CLASS = "org.springframework.beans.factory.annotation.CustomAutowireConfigurer";

  @NonNls String LOOKUP_ANNOTATION = "org.springframework.beans.factory.annotation.Lookup";

  // tests
  @NonNls String CONTEXT_HIERARCHY = "org.springframework.test.context.ContextHierarchy";
  @NonNls String CONTEXT_CONFIGURATION = "org.springframework.test.context.ContextConfiguration";
  @NonNls String TRANSACTION_CONFIGURATION = "org.springframework.test.context.transaction.TransactionConfiguration";
  @NonNls String TEST_PROPERTY_SOURCE = "org.springframework.test.context.TestPropertySource";
  @NonNls String TEST_SQL = "org.springframework.test.context.jdbc.Sql";
  @NonNls String TEST_SQL_GROUP = "org.springframework.test.context.jdbc.SqlGroup";
  @NonNls String TEST_SQL_CONFIG = "org.springframework.test.context.jdbc.SqlConfig";
  @NonNls String DIRTIES_CONTEXT = "org.springframework.test.annotation.DirtiesContext";

  // transaction
  @NonNls String TRANSACTIONAL = "org.springframework.transaction.annotation.Transactional";
  @NonNls String JAVAX_TRANSACTIONAL = "javax.transaction.Transactional";
  @NonNls String PLATFORM_TRANSACTION_MANAGER = "org.springframework.transaction.PlatformTransactionManager";

  // jmx
  @NonNls String JMX_MANAGED_OPERATION = "org.springframework.jmx.export.annotation.ManagedOperation";
  @NonNls String JMX_MANAGED_ATTRIBUTE = "org.springframework.jmx.export.annotation.ManagedAttribute";

  //messaging
  @NonNls String MESSAGE_MAPPING = "org.springframework.messaging.handler.annotation.MessageMapping";
  @NonNls String SEND_TO = "org.springframework.messaging.handler.annotation.SendTo";

  // scheduling
  @NonNls String SCHEDULED = "org.springframework.scheduling.annotation.Scheduled";
  @NonNls String SCHEDULES = "org.springframework.scheduling.annotation.Schedules";
  @NonNls String ASYNC = "org.springframework.scheduling.annotation.Async";

  // test transactions
  @NonNls String TEST_BEFORE_TRANSACTION = "org.springframework.test.context.transaction.BeforeTransaction";
  @NonNls String TEST_AFTER_TRANSACTION = "org.springframework.test.context.transaction.AfterTransaction";

  @NonNls String JAVAX_SERVLET_WEB_SERVLET = "javax.servlet.annotation.WebServlet";
  @NonNls String JAKARTA_SERVLET_WEB_SERVLET = "jakarta.servlet.annotation.WebServlet";
  @NonNls String JAVAX_RS_PATH = "javax.ws.rs.Path";
  @NonNls String JAKARTA_RS_PATH = "jakarta.ws.rs.Path";
  String[] PRIORITY_ANNOTATIONS = {"javax.annotation.Priority", "jakarta.annotation.Priority"};

  @NonNls String ENABLE_TRANSACTION_MANAGEMENT = "org.springframework.transaction.annotation.EnableTransactionManagement";

  String DYNAMIC_PROPERTY_SOURCE = "org.springframework.test.context.DynamicPropertySource";

  String JSON_COMPONENT = "org.springframework.boot.jackson.JsonComponent";
}