// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.reactor;

import org.jetbrains.annotations.NonNls;

import java.util.List;

import static com.intellij.util.containers.ContainerUtil.immutableList;

/**
 * Constants from Reactor framework.
 */
public interface ReactorConstants {

  @NonNls String FLUX = "reactor.core.publisher.Flux";

  @NonNls String HOOKS = "reactor.core.publisher.Hooks";
  @NonNls String REACTOR_DEBUG_AGENT = "reactor.tools.agent.ReactorDebugAgent";

  // spring 5.2 reactive event wrappers, should have single <T> type parameter
  @NonNls List<String> REACTIVE_EVENT_WRAPPER_CLASSES = immutableList(
    FLUX,
    "reactor.core.publisher.Mono",
    "reactor.core.CorePublisher",
    "org.reactivestreams.Publisher",
    "io.reactivex.Flowable",
    "io.reactivex.Observable"
  );
}
