// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;

public abstract class SpringModificationTrackersManager {

  public static SpringModificationTrackersManager getInstance(Project project) {
    return project.getService(SpringModificationTrackersManager.class);
  }

  public abstract ModificationTracker getProfilesModificationTracker();

  public abstract ModificationTracker getMultipleContextsModificationTracker();

  public abstract ModificationTracker getCustomBeanParserModificationTracker();

  public abstract ModificationTracker getEndpointsModificationTracker();

  public abstract void fireActiveProfilesChanged();

  public abstract void fireMultipleContextsChanged();

  public abstract void fireCustomBeanParserChanged();

  public abstract ModificationTracker getOuterModelsModificationTracker();

  public abstract Object[] getOuterModelsDependencies();
}
