// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public interface SpringLocalModelProducer {
  ExtensionPointName<SpringLocalModelProducer> EP_NAME = new ExtensionPointName<>("com.intellij.spring.localModelProducer");

  @Nullable
  LocalAnnotationModel create(@NotNull PsiClass aClass, @NotNull Module module, @NotNull Set<String> activeProfiles);
}
