/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.testFramework.builders;

import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.WebModuleTestFixture;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface WebModuleFixtureBuilder extends JavaModuleFixtureBuilder<WebModuleTestFixture> {
  @SuppressWarnings("UnusedDeclaration")
  Object ______INITIALIZER______ = new Object() {
    {
      IdeaTestFixtureFactory.getFixtureFactory().registerFixtureBuilder(WebModuleFixtureBuilder.class, "com.intellij.testFramework.fixtures.impl.WebModuleFixtureBuilderImpl");
    }
  };

  @NotNull
  WebModuleFixtureBuilder addWebRoot(@NonNls @NotNull String rootPath, @NonNls @NotNull String relativePath);

  @NotNull
  WebModuleFixtureBuilder setWebXml(@NonNls @NotNull String path);
}
