/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.utils.JavaeeClass;
import org.jetbrains.annotations.NonNls;

public final class WebCommonClassNames {

  @NonNls public static final String JAVAX_SERVLET_CONTEXT = "javax.servlet.ServletContext";
  @NonNls public static final JavaeeClass SERVLET_CONTEXT = JavaeeClass.create(JAVAX_SERVLET_CONTEXT);
  @NonNls public static final String JAVAX_SERVLET = "javax.servlet.Servlet";
  @NonNls public static final String JAKARTA_SERVLET = "jakarta.servlet.Servlet";
  @NonNls public static final JavaeeClass SERVLET = JavaeeClass.create(JAVAX_SERVLET);

  @NonNls public static final JavaeeClass SERVLET_CONFIG = JavaeeClass.create("javax.servlet.ServletConfig");
  @NonNls public static final JavaeeClass SERVLET_EXCEPTION = JavaeeClass.create("javax.servlet.ServletException");

  @NonNls public static final String JAVAX_SERVLET_FILTER = "javax.servlet.Filter";
  @NonNls public static final String JAKARTA_SERVLET_FILTER ="javax.servlet.Filter";
  @NonNls public static final JavaeeClass SERVLET_FILTER = JavaeeClass.create(JAVAX_SERVLET_FILTER);

  @NonNls public static final JavaeeClass SERVLET_REQUEST = JavaeeClass.create("javax.servlet.ServletRequest");

  @NonNls public static final JavaeeClass SERVLET_CONTEXT_LISTENER = JavaeeClass.create("javax.servlet.ServletContextListener");
  @NonNls public static final JavaeeClass HTTP_SESSION_LISTENER = JavaeeClass.create("javax.servlet.http.HttpSessionListener");
  @NonNls public static final JavaeeClass HTTP_SESSION_ATTRIBUTE_LISTENER = JavaeeClass.create("javax.servlet.http.HttpSessionAttributeListener");

  @NonNls public static final JavaeeClass JSP_CONTEXT = JavaeeClass.create("javax.servlet.jsp.JspContext");
  @NonNls public static final JavaeeClass JSP_WRITER = JavaeeClass.create("javax.servlet.jsp.JspWriter");

  @NonNls public static final JavaeeClass HTTP_COOKIE = JavaeeClass.create("javax.servlet.http.Cookie");
  @NonNls public static final JavaeeClass HTTP_PUSH_PUBLISHER = JavaeeClass.create("javax.servlet.http.PushBuilder");
  @NonNls public static final String JAVAX_HTTP_SESSION = "javax.servlet.http.HttpSession";
  @NonNls public static final JavaeeClass HTTP_SESSION = JavaeeClass.create(JAVAX_HTTP_SESSION);
  @NonNls public static final String JAVAX_HTTP_SERVLET_REQUEST = "javax.servlet.http.HttpServletRequest";
  @NonNls public static final JavaeeClass HTTP_SERVLET_REQUEST = JavaeeClass.create(JAVAX_HTTP_SERVLET_REQUEST);

  @NonNls public static final String JAVAX_HTTP_SERVLET_RESPONSE = "javax.servlet.http.HttpServletResponse";
  @NonNls public static final JavaeeClass HTTP_SERVLET_RESPONSE = JavaeeClass.create(JAVAX_HTTP_SERVLET_RESPONSE);

  @NonNls public static final JavaeeClass ANNOTATION_INIT_PARAM = JavaeeClass.create("javax.servlet.annotation.InitParam");
  @NonNls public static final JavaeeClass ANNOTATION_WEB_FILTER = JavaeeClass.create("javax.servlet.annotation.WebFilter");
  @NonNls public static final JavaeeClass ANNOTATION_WEB_LISTENER = JavaeeClass.create("javax.servlet.annotation.WebListener");
  @NonNls public static final JavaeeClass ANNOTATION_WEB_SERVLET = JavaeeClass.create("javax.servlet.annotation.WebServlet");
}
