package com.intellij.javaee.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.registry.Registry;

/**
 * Any present extension point unlocks Java EE (Legacy) project wizard.
 */
public final class JavaeeLegacyWizardUnlock {
  private static final ExtensionPointName<JavaeeLegacyWizardUnlock> EP_NAME =
    ExtensionPointName.create("com.intellij.javaee.legacy.project.wizard");

  private static volatile boolean isWarningShown = false;

  public static boolean isAvailable() {
    if (Registry.is("javaee.legacy.project.wizard", false)) {
      return true;
    }

    boolean hasAnyExtensions = EP_NAME.hasAnyExtensions();
    if (hasAnyExtensions && ApplicationManager.getApplication().isInternal()) {
      if (!isWarningShown) {
        Logger.getInstance(JavaeeLegacyWizardUnlock.class).warn(
          "Legacy Java EE wizards are not shown in internal mode. " +
          "Please enable `javaee.legacy.project.wizard` registry key explicitly to show them."
        );
        isWarningShown = true;
      }
      return false;
    }
    return hasAnyExtensions;
  }
}
