/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.javaee.ui.DefaultUserResponse;

import java.util.Collection;
import java.util.Collections;

/**
 * @author peter
 */
public class JavaeeDeleteProvider extends JamDeleteProvider {

  public JavaeeDeleteProvider(final DefaultUserResponse response, final Collection<CommonModelElement> elements) {
    super(response, elements);
  }

  public JavaeeDeleteProvider(final CommonModelElement element, final DefaultUserResponse response) {
    this(response, Collections.singletonList(element));
  }
}
