/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.module.view;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;
import java.util.function.Supplier;

import static com.intellij.openapi.util.NlsActions.ActionDescription;
import static com.intellij.openapi.util.NlsActions.ActionText;

public abstract class JavaeeAbstractAction extends AnAction {
  protected JavaeeAbstractAction(@ActionText String text, @ActionDescription String description, Icon icon) {
    super(text, description, icon);
  }

  protected JavaeeAbstractAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, Icon icon) {
    super(text, description, icon);
  }

  /**
   * should be visible when either EJB group (or descendant) is selected in ejb view
   * @param e
   */
  @Override
  public void update(@NotNull AnActionEvent e) {
    setActive(e, isActive(e));
  }

  protected abstract boolean isActive(@NotNull AnActionEvent e);

  public static void setActive(@NotNull AnActionEvent e, boolean active) {
    final Presentation presentation = e.getPresentation();

    if (e.isFromActionToolbar()) {
      presentation.setEnabled(active);
    }
    else {
      presentation.setVisible(active);
    }
  }
}
