/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.facet;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public abstract class JavaeeFacetUtil {

  public static JavaeeFacetUtil getInstance() {
    return ApplicationManager.getApplication().getService(JavaeeFacetUtil.class);
  }

  public abstract JavaeeFacet[] getAllJavaeeFacets(Module... modules);

  public abstract JavaeeFacet[] getAllJavaeeFacets(Project project);


  public abstract <F extends JavaeeFacet> Collection<F> getJavaeeFacets(FacetTypeId<F> type, Module... modules);

  public abstract <F extends JavaeeFacet> Collection<F> getJavaeeFacets(FacetTypeId<F> type, Project project);


  public abstract Collection<FacetTypeId<? extends JavaeeFacet>> getAllJavaeeFacetTypes();

  public abstract Collection<FacetTypeId<? extends JavaeeFacet>> getSingletonCollection(FacetTypeId<? extends JavaeeFacet> facetTypeId);

  @Nullable
  public abstract <F extends JavaeeFacet> F getJavaeeFacet(VirtualFile file, FacetTypeId<F> type, Project project);

  @Nullable
  public abstract JavaeeFacet getJavaeeFacet(VirtualFile file, Project project);

  public abstract void setFacetForMockElement(DomElement element, JavaeeFacet facet);

  @Nullable
  public abstract <F extends JavaeeFacet> F getJavaeeFacet(final @NotNull JavaeeModelElement element, FacetTypeId<F> type);

  @Nullable
  public abstract <F extends JavaeeFacet> F getJavaeeFacet(@Nullable PsiElement element, FacetTypeId<F> type);

  @Nullable
  public abstract <F extends JavaeeFacet> F getJavaeeFacet(ConvertContext convertContext, FacetTypeId<F> typeId);

  @Nullable
  public abstract JavaeeFacet getJavaeeFacet(ConvertContext convertContext);


  public abstract boolean showFacetDescriptorsSettingsEditor(JavaeeFacet facet);
}
